/****** Object:  StoredProcedure [dbo].[P_PDV_VD_IT_VD_PBM_RETIRAR_PRODUTO_SEM_VINCULO]    Script Date: 01/27/2014 18:18:50 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_VD_PBM_RETIRAR_PRODUTO_SEM_VINCULO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_IT_VD_PBM_RETIRAR_PRODUTO_SEM_VINCULO]
GO
GO 
--EXEC P_PDV_VD_IT_VD_PBM_RETIRAR_PRODUTO_SEM_VINCULO 1,540,0
CREATE PROCEDURE P_PDV_VD_IT_VD_PBM_RETIRAR_PRODUTO_SEM_VINCULO 
												@CD_EMP INT, 
												@CD_FILIAL INT,
												@FLAG_ACAO INT=0 AS
/*
	@FLAG_ACAO
		0 - Analise
		1 - Exclusao
*/
SET NOCOUNT ON
CREATE TABLE #RsProcSemVincPBM (CD_EMP INT,
								CD_FILIAL INT,
								CD_VD INT,
								CD_IT INT,
								DS_PROD VARCHAR(300))
DECLARE 
@CD_VD INT,
@CD_IT INT,
@DS_PROD VARCHAR(200)

INSERT INTO #RsProcSemVincPBM
SELECT
	 PDV_VD_IT.CD_EMP,
	 PDV_VD_IT.CD_FILIAL,
	 PDV_VD_IT.CD_VD,
	 PDV_VD_IT.CD_IT,
	 EST_PROD.DS_PROD 
FROM
	PDV_VD_IT INNER JOIN PDV_VD_IT_VD_PBM ON
	PDV_VD_IT.CD_EMP = PDV_VD_IT_VD_PBM.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD_IT_VD_PBM.CD_VD AND
	PDV_VD_IT.CD_IT = PDV_VD_IT_VD_PBM.CD_IT 
	LEFT OUTER  JOIN EST_PROD_RC_CLI_CONV ON
	PDV_VD_IT.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	PDV_VD_IT.CD_PROD  = EST_PROD_RC_CLI_CONV.CD_PROD  
	LEFT OUTER  JOIN EST_PROD_FARMACIA_POPULAR ON
	PDV_VD_IT.CD_EMP = EST_PROD_FARMACIA_POPULAR.CD_EMP AND
	PDV_VD_IT.CD_PROD  = EST_PROD_FARMACIA_POPULAR.CD_PROD  
	INNER JOIN EST_PROD ON
	PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND
	PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.CD_PROD IS NULL
	and PDV_VD_IT.DT_VD >=getdate()-60
	AND PDV_VD_IT.CD_EMP =@CD_EMP
	AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
	AND EST_PROD_FARMACIA_POPULAR.CD_PROD  IS NULL

IF @FLAG_ACAO=1
BEGIN
DECLARE ProcProdPBMVinc CURSOR FAST_FORWARD FOR 
SELECT
	 CD_EMP,
	 CD_FILIAL,
	 CD_VD,
	 CD_IT,
	 DS_PROD 
FROM
	#RsProcSemVincPBM

	
OPEN ProcProdPBMVinc;
FETCH NEXT FROM ProcProdPBMVinc INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_IT,@DS_PROD 

WHILE @@FETCH_STATUS = 0
    BEGIN
		PRINT 'Analisando produto.: ' + @DS_PROD
		DELETE 
			PBM
        FROM 
			PDV_VD_IT_VD_PBM PBM 
        WHERE 
			CD_EMP =@CD_EMP
			AND CD_FILIAL=@CD_FILIAL
			AND CD_VD=@CD_VD
			AND CD_IT=@CD_IT

	FETCH NEXT FROM ProcProdPBMVinc INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_IT,@DS_PROD 
    END;
PRINT 'CONCLUIDO.';
CLOSE ProcProdPBMVinc;
DEALLOCATE ProcProdPBMVinc;
END
ELSE
BEGIN
	SELECT
		DISTINCT CD_FILIAL,
		DS_PROD
	FROM
	#RsProcSemVincPBM
END

DROP TABLE #RsProcSemVincPBM;